/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: AsiMaster_Public.h $
   Last Modification:
    $Id: AsiMaster_Public.h 7584 2010-04-29 14:23:08Z AndreasB $

    $Author: Eric $
    $Modtime: 19.09.08 11:40 $
    $Revision: 0 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    AS-Interface Master
    public

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
    2           13.04.10    andreasb
        Add command for transparent mode
        Add bus parameter operation mode ASI_MASTER_OPERATION_MODE_TRANSPARENT
    1           21.01.09    ES
        Created

**************************************************************************************/
/**
 * @file AsiMaster_Public.h
 *  AS-Interface Master - public definition of task
 *
 * The header contains the public definition of task.
 * It has to be included by another task to get access of task specfic definition.
 *
 * @note
 * The structures for the services must be packed on 1 byte of boundary.
 * The <code>#pragma</code> instructions are already planned for Microsoft compiler.
 * For gnu's compiler and Realview compiler the macros <code>__PACKED_PRE</code>
 * and <code>__PACKED_PRE</code> have to be added with the structural definition
 * in addition.
 */
#ifndef __ASI_MASTER_PUBLIC_H
#define __ASI_MASTER_PUBLIC_H

#define ASI_MASTER_INITIALIZE_REQ                       0x00005200
#define ASI_MASTER_INITIALIZE_CNF                       0x00005201

#define ASI_MASTER_REGISTER_REQ                         0x00005202
#define ASI_MASTER_REGISTER_CNF                         0x00005203

#define ASI_MASTER_GET_BUFFER_HANDLE_REQ                0x00005204
#define ASI_MASTER_GET_BUFFER_HANDLE_CNF                0x00005205

#define ASI_MASTER_SET_SLAVE_PARAM_REQ                  0x00005206
#define ASI_MASTER_SET_SLAVE_PARAM_CNF                  0x00005207

#define ASI_MASTER_SET_BUS_PARAM_REQ                    0x00005208
#define ASI_MASTER_SET_BUS_PARAM_CNF                    0x00005209

#define ASI_MASTER_GET_BUS_PARAM_REQ                    0x0000520A
#define ASI_MASTER_GET_BUS_PARAM_CNF                    0x0000520B

#define ASI_MASTER_SET_OFFLINE_MODE_REQ                 0x0000520C
#define ASI_MASTER_SET_OFFLINE_MODE_CNF                 0x0000520D

#define ASI_MASTER_READ_ACTUAL_CONFIG_REQ               0x00005210
#define ASI_MASTER_READ_ACTUAL_CONFIG_CNF               0x00005211

#define ASI_MASTER_READ_PARAMETER_IMAGE_REQ             0x00005212
#define ASI_MASTER_READ_PARAMETER_IMAGE_CNF             0x00005213

#define ASI_MASTER_GET_PERMANENT_CONFIG_REQ             0x00005214
#define ASI_MASTER_GET_PERMANENT_CONFIG_CNF             0x00005215

#define ASI_MASTER_GET_PERMANENT_PARAMETER_REQ          0x00005216
#define ASI_MASTER_GET_PERMANENT_PARAMETER_CNF          0x00005217

#define ASI_MASTER_SLAVE_SERIAL_READ_REQ                0x00005218
#define ASI_MASTER_SLAVE_SERIAL_READ_CNF                0x00005219

#define ASI_MASTER_GET_SLAVE_DIAG_REQ                   0x0000521A
#define ASI_MASTER_GET_SLAVE_DIAG_CNF                   0x0000521B

#define ASI_MASTER_EXECUTE_COMMAND_REQ                  0x0000521C
#define ASI_MASTER_EXECUTE_COMMAND_CNF                  0x0000521D

#define ASI_MASTER_WRITE_PARAMETER_REQ                  0x0000521E
#define ASI_MASTER_WRITE_PARAMETER_CNF                  0x0000521F

#define ASI_MASTER_CHANGE_SLAVE_ADDRESS_REQ             0x00005220
#define ASI_MASTER_CHANGE_SLAVE_ADDRESS_CNF             0x00005221

#define ASI_MASTER_WRITE_EXT_ID1_CODE_REQ               0x00005222
#define ASI_MASTER_WRITE_EXT_ID1_CODE_CNF               0x00005223

#define ASI_MASTER_GET_LPS_REQ                          0x00005224
#define ASI_MASTER_GET_LPS_CNF                          0x00005225

#define ASI_MASTER_GET_LAS_REQ                          0x00005226
#define ASI_MASTER_GET_LAS_CNF                          0x00005227

#define ASI_MASTER_GET_LDS_REQ                          0x00005228
#define ASI_MASTER_GET_LDS_CNF                          0x00005229

#define ASI_MASTER_GET_LPF_REQ                          0x0000522A
#define ASI_MASTER_GET_LPF_CNF                          0x0000522B

#define ASI_MASTER_GET_EXECUTION_CONTROL_FLAGS_REQ      0x0000522C
#define ASI_MASTER_GET_EXECUTION_CONTROL_FLAGS_CNF      0x0000522D

#define ASI_MASTER_READ_WRITE_OBJECTS_REQ               0x0000522E
#define ASI_MASTER_READ_WRITE_OBJECTS_CNF               0x0000522F

#define ASI_MASTER_READ_IDENTIFICATION_STRING_REQ       0x00005230
#define ASI_MASTER_READ_IDENTIFICATION_STRING_CNF       0x00005231

#define ASI_MASTER_READ_DIAGNOSTIC_STRING_REQ           0x00005232
#define ASI_MASTER_READ_DIAGNOSTIG_STRING_CNF           0x00005233

#define ASI_MASTER_READ_PARAMETER_STRING_REQ            0x00005234
#define ASI_MASTER_READ_PARAMETER_STRING_CNF            0x00005235

#define ASI_MASTER_WRITE_PARAMETER_STRING_REQ           0x00005236
#define ASI_MASTER_WRITE_PARAMETER_STRING_CNF           0x00005237

#define ASI_MASTER_SET_OPERATION_MODE_REQ               0x00005238
#define ASI_MASTER_SET_OPERATION_MODE_CNF               0x00005239

#define ASI_MASTER_SET_DATA_EXCHANGE_ACTIVE_REQ         0x0000523A
#define ASI_MASTER_SET_DATA_EXCHANGE_ACTIVE_CNF         0x0000523B

#define ASI_MASTER_SET_AUTO_ADDRESS_ENABLE_REQ          0x0000523C
#define ASI_MASTER_SET_AUTO_ADDRESS_ENABLE_CNF          0x0000523D

#define ASI_MASTER_GET_AUTO_ADDRESS_ENABLE_REQ          0x0000523E
#define ASI_MASTER_GET_AUTO_ADDRESS_ENABLE_CNF          0x0000523F

#define ASI_MASTER_GET_SLAVE_PARAM_REQ                  0x00005240
#define ASI_MASTER_GET_SLAVE_PARAM_CNF                  0x00005241

#define ASI_MASTER_TRANSPARENT_COMMAND_REQ              0x00005242
#define ASI_MASTER_TRANSPARENT_COMMAND_CNF              0x00005243

#define ASI_MASTER_STATE_CHANGE_IND                     0x000052FE
#define ASI_MASTER_STATE_CHANGE_RES                     0x000052FF

/*************************************************************************************/

#define ASI_MASTER_MAX_SLAVES          63
#define ASI_MASTER_MAX_CONFIG_SLAVES   62

#define ASI_MASTER_ALL_SLAVES          255

#define ASI_MASTTER_MIN_SLAVE_ADDR_W0  0
#define ASI_MASTTER_MIN_SLAVE_ADDR     1

#define ASI_MASTER_MAX_SLAVE_ADDR_STD  31
#define ASI_MASTER_MAX_SLAVE_ADDR_EXT  62

#define ASI_MASTER_ID_CODE_EXT_SLAVE   0x0A

#define ASI_MASTER_FIX_OFFSET_DIGITAL_OFFSET            0
#define ASI_MASTER_FIX_OFFSET_DIGITAL_IMMAGE_LENGHT    62
#define ASI_MASTER_FIX_OFFSET_ANALOG_IMMAGE_LENGHT    496

#define ASI_MASTER_FIX_OFFSET_ANALOG_OFFSET  ASI_MASTER_FIX_OFFSET_DIGITAL_IMMAGE_LENGHT
#define ASI_MASTER_FIX_OFFSET_IMMAGE_LENGHT  ASI_MASTER_FIX_OFFSET_DIGITAL_IMMAGE_LENGHT+ \
                                             ASI_MASTER_FIX_OFFSET_ANALOG_IMMAGE_LENGHT

#define ASI_MASTER_PCD_SLAVE_DEFAULT_VALUE             0x0F
#define ASI_MASTER_PARAMETER_SLAVE_DEFAULT_VALUE       0x0F

#define ASI_MASTER_ANALOG_BIG_DEFAULT 0xFF7F
#define ASI_MASTER_ANALOG_LIT_DEFAULT 0x7FFF
#define ASI_MASTER_TRANSP_DEFAULT     0x0000

#define ASI_MASTER_MAX_ANALOG_CHANNELS           1
#define ASI_MASTER_MAX_DIGITAL_CHANNELS          1
#define ASI_MASTER_MAX_CHANNEL \
          (ASI_MASTER_MAX_ANALOG_CHANNELS + ASI_MASTER_MAX_DIGITAL_CHANNELS)

#define ASI_MASTER_MAX_DIGITAL_BIT_CNT             4
#define ASI_MASTER_ANALOG_BIT_CNT_1_CH            16
#define ASI_MASTER_ANALOG_BIT_CNT_2_CH            32
#define ASI_MASTER_ANALOG_BIT_CNT_3_CH            48
#define ASI_MASTER_ANALOG_BIT_CNT_4_CH            64

#define ASI_MASTER_ASLAVE_ID1_MASK                0x07




/*************************************************************************************/
/** @name Queue Name
 *
 * Use the queue name to identify the process queue of task 'AS-Interface Master'.
 * Example for internal identification:<br>
 * @code
 * TLR_RESULT eRslt;
 * TLR_HANDLE hQue;
 * TLR_UINT   uiInstance = 0;
 *
 * eRslt = TLR_QUE_IDENTIFY_INTERN(
 *                                 ASI_MASTER_QUEUE_NAME,
 *                                 uiInstance,
 *                                 &hQue
 *                                );
 * @endcode
 * <br>
 * Example for external or normal identification:<br>
 * @code
 * TLR_RESULT      eRslt;
 * TLR_QUE_LINK_T  tQue;
 * TLR_UINT        uiInstance = 0;
 *
 * eRslt = TLR_QUE_IDENTIFY(ASI_MASTER_QUEUE_NAME, uiInstance, &tQue);
 * @endcode
 * <br>
 * @{
 */
/** queue name */
#define ASI_MASTER_QUEUE_NAME   "QUE_ASIMASTER"

/** @} */

/*************************************************************************************/
/* packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__ASI_MASTER_PACKET)
#endif

/** @name Packet Data Definition
 *
 * The following defined structures represent the specific parameter
 * of the several services, which are supported by the task.
 * @{
 */

/*************************************************************************************/
/** type of <code>ASI_MASTER_BUS_PARAM_Ttag</code> */
typedef struct ASI_MASTER_BUS_PARAM_Ttag
  ASI_MASTER_BUS_PARAM_T;

#define ASI_MASTER_OPERATION_MODE_CONFIGURATION         0x00000000L
#define ASI_MASTER_OPERATION_MODE_PROTECTED             0x00000001L
#define ASI_MASTER_OPERATION_MODE_TRANSPARENT           0x00000002L

#define ASI_MASTER_DATA_EXCHANGE_INACTIVE               0x00000000L
#define ASI_MASTER_DATA_EXCHANGE_ACTIVE                 0x00000001L
#define ASI_MASTER_DATA_EXCHANGE_OFFLINE_ACTIVE         0x00000002L

#define ASI_MASTER_AUTO_ADDRESS_DISABLE                 0x00000000L
#define ASI_MASTER_AUTO_ADDRESS_ENABLE                  0x00000001L

#define ASI_MASTER_PROCESS_DATA_MODE_CONFIGURED_OFFSET  0x00000000L
#define ASI_MASTER_PROCESS_DATA_MODE_FIX_OFFSET         0x00000001L

#define ASI_MASTER_AUTO_CLEAR_MODE_INACTIVE             0x00000000L
#define ASI_MASTER_AUTO_CLEAR_MODE_MISSING              0x00000001L
#define ASI_MASTER_AUTO_CLEAR_MODE_FAULT                0x00000002L
#define ASI_MASTER_AUTO_CLEAR_MODE_MISSING_FAULT        0x00000003L

#define ASI_MASTER_DATA_FORMAT_MODE_BIG_ENDIAN          0x00000000L
#define ASI_MASTER_DATA_FORMAT_MODE_LITTLE_ENDIAN       0x00000001L

__PACKED_PRE struct ASI_MASTER_BUS_PARAM_Ttag
{
  TLR_UINT32 ulOperationMode;
  TLR_UINT32 ulDataExchange;
  TLR_UINT32 ulAutoAddress;
  TLR_UINT32 ulProcessDataMode;
  TLR_UINT32 ulAutoClearMode;
  TLR_UINT32 ulDataFormatMode;

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_SLAVE_CONFIG_OFFSET_DESCR_Ttag</code> */
typedef struct ASI_MASTER_SLAVE_CONFIG_OFFSET_DESCR_Ttag
  ASI_MASTER_SLAVE_CONFIG_OFFSET_DESCR_T;

#define ASI_MASTER_MAX_DESCR_COUNT                     4

__PACKED_PRE struct ASI_MASTER_SLAVE_CONFIG_OFFSET_DESCR_Ttag
{
  TLR_UINT16 usOffsetDescrLen;
  TLR_UINT8  bInputCnt;
  TLR_UINT8  bOutputCnt;
  TLR_UINT16 ausOffset[ASI_MASTER_MAX_DESCR_COUNT];

}__PACKED_POST;
/*************************************************************************************/


/*************************************************************************************/
/** type of <code>ASI_MASTER_SLAVE_CONFIG_DATA_TYPE_DESCR_Ttag</code> */
typedef struct ASI_MASTER_SLAVE_CONFIG_DATA_TYPE_DESCR_Ttag
  ASI_MASTER_SLAVE_CONFIG_DATA_TYPE_DESCR_T;

#define ASI_MASTER_SLAVE_PARAM_BIT_DATA_LEN_MSK  0x00FF
#define ASI_MASTER_SLAVE_PARAM_DIRECTION_MSK     0x8000

__PACKED_PRE struct ASI_MASTER_SLAVE_CONFIG_DATA_TYPE_DESCR_Ttag
{
  TLR_UINT16 usDataTypeDescrLen;
  TLR_UINT16 ausDataType[ASI_MASTER_MAX_DESCR_COUNT];

}__PACKED_POST;
/*************************************************************************************/


/*************************************************************************************/
/** type of <code>ASI_MASTER_SLAVE_PARAM_HEADER_Ttag</code> */
typedef struct ASI_MASTER_SLAVE_PARAM_HEADER_Ttag
  ASI_MASTER_SLAVE_PARAM_HEADER_T;

#define ASI_MASTER_CONFIG_FLAG_IGNORE_PP            0x01
#define ASI_MASTER_CONFIG_FLAG_IGNORE_PCD           0x02
#define ASI_MASTER_CONFIG_FLAG_IGNORE_LPS           0x04
#define ASI_MASTER_CONFIG_FLAG_RESTART              0x08

#define ASI_MASTER_DEVICE_FLAG_LPS                  0x80

#define ASI_MASTER_VERSION_FLAG_CONFIG_ID1_ID2       0x04

__PACKED_PRE struct ASI_MASTER_SLAVE_PARAM_HEADER_Ttag
{
  /* general device description section */
  TLR_UINT16 usDataSetLen;
  TLR_UINT8  bDevFlag;
  TLR_UINT8  bParam;
  TLR_UINT8  bIoConfig;
  TLR_UINT8  bIdCode;
  TLR_UINT8	 bId1Code;
  TLR_UINT8	 bId2Code;

  TLR_UINT8	 bVersionFlags;
  TLR_UINT8  bConfigFlags;
  TLR_UINT8  abOctet[6];

}__PACKED_POST;
/*************************************************************************************/


/*************************************************************************************/
/** type of <code>ASI_MASTER_SLAVE_PARAM_Ttag</code> */
typedef struct ASI_MASTER_SLAVE_PARAM_Ttag
  ASI_MASTER_SLAVE_PARAM_T;

#define ASI_MASTER_ACTION_SET_SLAVE_PARAM         0x01
#define ASI_MASTER_ACTION_CLEAR_SLAVE_PARAM       0x02
#define ASI_MASTER_ACTION_CLEAR_ALL_SLAVE_PARAM   0x03

__PACKED_PRE struct ASI_MASTER_SLAVE_PARAM_Ttag
{
  TLR_UINT8  bNotUsed;
  TLR_UINT8  bSlaveAddr;
  TLR_UINT8  bAction;
  TLR_UINT8  bReserved;

  ASI_MASTER_SLAVE_PARAM_HEADER_T tSlaveParamHeader;

  TLR_UINT8  abParamData[sizeof(ASI_MASTER_SLAVE_CONFIG_DATA_TYPE_DESCR_T)+
                         sizeof(ASI_MASTER_SLAVE_CONFIG_OFFSET_DESCR_T)];

}__PACKED_POST;

#define ASI_MASTER_SLAVE_PARAM_PRE_HEADER_SIZE   \
  (sizeof(TLR_UINT8) * 4)

#define ASI_MASTER_SLAVE_PARAM_MIN_PACKET_SIZE   \
  (ASI_MASTER_SLAVE_PARAM_PRE_HEADER_SIZE  +     \
   sizeof(ASI_MASTER_SLAVE_PARAM_HEADER_T)+      \
   sizeof(TLR_UINT8)* 6)

#define ASI_MASTER_SLAVE_MAX_PARAM_SIZE \
  sizeof(ASI_MASTER_SLAVE_PARAM_T)

#define ASI_MASTER_SLAVE_MIN_PARAM_SIZE          \
  (sizeof(ASI_MASTER_SLAVE_PARAM_HEADER_T)+      \
   sizeof(TLR_UINT8)* 6)
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_EXTENDED_STATE_Ttag</code> */
typedef struct ASI_MASTER_EXTENDED_STATE_Ttag
  ASI_MASTER_EXTENDED_STATE_T;

#define ASI_MASTER_LIST_SIZE                            8

#define ASI_MASTER_GLOBAL_FLAGS_CONTROL                 0x01
#define ASI_MASTER_GLOBAL_FLAGS_AUTO_CLEAR              0x02
#define ASI_MASTER_GLOBAL_FLAGS_NONE_EXCHANGE           0x04
#define ASI_MASTER_GLOBAL_FLAGS_NOT_READY               0x20
#define ASI_MASTER_GLOBAL_FLAGS_INACTIVE                0x40
#define ASI_MASTER_GLOBAL_FLAGS_TRANSPARENT_MODE        0x80

#define ASI_MASTER_MASTER_STATE_OFFLINE                 0x00
#define ASI_MASTER_MASTER_STATE_STOP                    0x40
#define ASI_MASTER_MASTER_STATE_CLEAR                   0x80
#define ASI_MASTER_MASTER_STATE_OPERATE                 0xC0

#define ASI_MASTER_ASI_FLAGS_CONFIG_OK                0x0001
#define ASI_MASTER_ASI_FLAGS_LDS0                     0x0002
#define ASI_MASTER_ASI_FLAGS_AUTO_ADDRESS_ASSIGN      0x0004
#define ASI_MASTER_ASI_FLAGS_AUTO_ADDRESS_AVAILABLE   0x0008
#define ASI_MASTER_ASI_FLAGS_CONFIGURATION_ACTIVE     0x0010
#define ASI_MASTER_ASI_FLAGS_NORMAL_OPERATION_ACTIVE  0x0020
#define ASI_MASTER_ASI_FLAGS_APF_NOT_APO              0x0040
#define ASI_MASTER_ASI_FLAGS_OFFLINE_READY            0x0080
#define ASI_MASTER_ASI_FLAGS_PERIPHERY_OK             0x0100

__PACKED_PRE struct ASI_MASTER_EXTENDED_STATE_Ttag
{
  TLR_UINT8  bGlobalFlags;
  TLR_UINT8  bMasterState;

  TLR_UINT8  abReserved1[6];

  TLR_UINT16 usAsiFlags;

  TLR_UINT8  abReserved2[6];

  TLR_UINT8  abProjectedList[ASI_MASTER_LIST_SIZE];
  TLR_UINT8  abReserved3[ASI_MASTER_LIST_SIZE];
  TLR_UINT8  abActivatedList[ASI_MASTER_LIST_SIZE];
  TLR_UINT8  abReserved4[ASI_MASTER_LIST_SIZE];
  TLR_UINT8  abDiagnosticList[ASI_MASTER_LIST_SIZE];
  TLR_UINT8  abReserved5[ASI_MASTER_LIST_SIZE];

  TLR_UINT8  abDetectedList[ASI_MASTER_LIST_SIZE];
  TLR_UINT8  abReserved6[ASI_MASTER_LIST_SIZE];

  TLR_UINT8  abPeripheryFaultList[ASI_MASTER_LIST_SIZE];
  TLR_UINT8  abReserved7[ASI_MASTER_LIST_SIZE];


}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_SLAVE_DIAG_Ttag</code> */
typedef struct ASI_MASTER_SLAVE_DIAG_Ttag
  ASI_MASTER_SLAVE_DIAG_T;

#define ASI_MASTER_SLAVE_DIAG_BUFFER_SIZE                        8
#define ASI_MASTER_DIAG_FLAG_DIAG_INFORMATION_LOST      0x00000001L

__PACKED_PRE struct ASI_MASTER_SLAVE_DIAG_Ttag
{
  TLR_UINT32 ulDiagFlags;
  TLR_UINT32 ulNumOfDiagInfos;
  TLR_RESULT aeSlaveError[ASI_MASTER_SLAVE_DIAG_BUFFER_SIZE];

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_READ_WRITE_OBJECT_DATA_Ttag</code> */
typedef struct ASI_MASTER_READ_WRITE_OBJECT_DATA_Ttag
  ASI_MASTER_READ_WRITE_OBJECT_DATA_T;

#define ASI_MASTER_MAX_OBJECTS_READ_WRITE_DATA 220

/* Acyclic commands/response for CTT2 slaves */
#define CTT2_STANDARD_READ_REQUEST                               16 /* Standard                   */
#define CTT2_STANDARD_READ_RESPONSE_OK                           80 /* Standard                   */
#define CTT2_STANDARD_READ_RESPONSE_NOT_OK                      144 /* Standard                   */
#define CTT2_STANDARD_WRITE_REQUEST                              17 /* Standard                   */
#define CTT2_STANDARD_WRITE_RESPONSE_OK                          81 /* Standard                   */
#define CTT2_STANDARD_WRITE_RESPONSE_NOT_OK                     145 /* Standard                   */
#define CTT2_VENDOR_SPECIFIC_READ_REQUEST                        18 /* Vendor specific            */
#define CTT2_VENDOR_SPECIFIC_READ_RESPONSE_OK                    82 /* Vendor specific            */
#define CTT2_VENDOR_SPECIFIC_READ_RESPONSE_NOT_OK               146 /* Vendor specific            */
#define CTT2_VENDOR_SPECIFIC_WRITE_REQUEST                       19 /* Vendor specific            */
#define CTT2_VENDOR_SPECIFIC_WRITE_RESPONSE_OK                   83 /* Vendor specific            */
#define CTT2_VENDOR_SPECIFIC_WRITE_RESPONSE_NOT_OK              147 /* Vendor specific            */
#define CTT2_VENDOR_SPECIFIC_SELECTIVE_READ_REQUEST_FROM_BUFFER  22 /* Vendor specific            */
#define CTT2_VENDOR_SPECIFIC_SELECTIVE_READ_REQUEST              24 /* Vendor specific            */
#define CTT2_VENDOR_SPECIFIC_SELECTIVE_READ_RESPONSE_OK          88 /* Vendor specific            */
#define CTT2_VENDOR_SPECIFIC_SELECTIVE_READ_RESPONSE_NOT_OK     152 /* Vendor specific            */
#define CTT2_VENDOR_SPECIFIC_SELECTIVE_WRITE_REQUEST_IN_BUFFER   23 /* Vendor specific            */
#define CTT2_VENDOR_SPECIFIC_SELECTIVE_WRITE_REQUEST             25 /* Vendor specific            */
#define CTT2_VENDOR_SPECIFIC_SELECTIVE_WRITE_RESPONSE_OK         89 /* Vendor specific            */
#define CTT2_VENDOR_SPECIFIC_SELECTIVE_WRITE_RESPONSE_NOT_OK    153 /* Vendor specific            */
#define CTT2_VENDOR_SPECIFIC_EXCHANGE_REQUEST                    29 /* Vendor specific            */
#define CTT2_VENDOR_SPECIFIC_EXCHANGE_RESPONSE_OK                93 /* Vendor specific            */
#define CTT2_VENDOR_SPECIFIC_EXCHANGE_RESPONSE_NOT_OK           157 /* Vendor specific            */
#define CTT2_DEVICE_GROUP_READ_REQUEST                           20 /* Device group specific      */
#define CTT2_DEVICE_GROUP_READ_RESPONSE_OK                       84 /* Device group specific      */
#define CTT2_DEVICE_GROUP_READ_RESPONSE_NOT_OK                  148 /* Device group specific      */
#define CTT2_DEVICE_GROUP_WRITE_REQUEST                          21 /* Device group specific      */
#define CTT2_DEVICE_GROUP_WRITE_RESPONSE_OK                      85 /* Device group specific      */
#define CTT2_DEVICE_GROUP_WRITE_RESPONSE_NOT_OK                 149 /* Device group specific      */
#define CTT2_DEVICE_GROUP_SELECTIVE_READ_REQUEST_FROM_BUFFER     31 /* Device group specific      */
#define CTT2_DEVICE_GROUP_SELECTIVE_READ_REQUEST                 26 /* Device group specific      */
#define CTT2_DEVICE_GROUP_SELECTIVE_READ_RESPONSE_OK             90 /* Device group specific      */
#define CTT2_DEVICE_GROUP_SELECTIVE_READ_RESPONSE_NOT_OK        154 /* Device group specific      */
#define CTT2_DEVICE_GROUP_SELECTIVE_WRITE_REQUEST_IN_BUFFER      32 /* Device group specific      */
#define CTT2_DEVICE_GROUP_SELECTIVE_WRITE_REQUEST                27 /* Device group specific      */
#define CTT2_DEVICE_GROUP_SELECTIVE_WRITE_RESPONSE_OK            91 /* Device group specific      */
#define CTT2_DEVICE_GROUP_SELECTIVE_WRITE_RESPONSE_NOT_OK       155 /* Device group specific      */
#define CTT2_DEVICE_GROUP_EXCHANGE_REQUEST                       30 /* Device group specific      */
#define CTT2_DEVICE_GROUP_EXCHANGE_RESPONSE_OK                   94 /* Device group specific      */
#define CTT2_DEVICE_GROUP_EXCHANGE_RESPONSE_NOT_OK              158 /* Device group specific      */

#define CTT2_INDEX_ID_OBJECT                                   0x00 /* Index. for standard service*/
#define CTT2_INDEX_DIAGNOSIS                                   0x01 /* Index. for standard service*/
#define CTT2_DEVICE_GROUP_OBJECT                               0x80 /* Index. for standard service*/

#define CTT2_NO_ERROR                                          0x00 /* Standard error code        */
#define CTT2_ILLEGAL_INDEX                                     0x01 /* Standard error code        */
#define CTT2_ILLEGAL_LENGTH                                    0x02 /* Standard error code        */
#define CTT2_REQUEST_NOT_IMPLEMENTED                           0x03 /* Standard error code        */
#define CTT2_BUSY                                              0x04 /* Standard error code        */
#define CTT2_LAST_ACYCLIC_REQUEST_NOT_ACKNOWLEDGED             0x05 /* Standard error code        */
#define CTT2_ILLEGAL_SUBINDEX                                  0x06 /* Standard error code        */
#define CTT2_COMMAND_IS_MISSING                                0x07 /* Standard error code        */

__PACKED_PRE struct ASI_MASTER_READ_WRITE_OBJECT_DATA_Ttag
{
  TLR_UINT32 ulAddress;
  TLR_UINT8  bReadCommand;
  TLR_UINT8  abData[ASI_MASTER_MAX_OBJECTS_READ_WRITE_DATA];

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_READ_IDENTIFICATION_STRING_REQ_DATA_Ttag</code> */
typedef struct ASI_MASTER_READ_IDENTIFICATION_STRING_REQ_DATA_Ttag
  ASI_MASTER_READ_IDENTIFICATION_STRING_REQ_DATA_T;

/** type of <code>ASI_MASTER_READ_IDENTIFICATION_STRING_CNF_DATA_Ttag</code> */
typedef struct ASI_MASTER_READ_IDENTIFICATION_STRING_CNF_DATA_Ttag
  ASI_MASTER_READ_IDENTIFICATION_STRING_CNF_DATA_T;

#define ASI_MASTER_MAX_READ_IDENTIFICATION_STRING_DATA 219

__PACKED_PRE struct ASI_MASTER_READ_IDENTIFICATION_STRING_REQ_DATA_Ttag
{
  TLR_UINT32 ulAddress;

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_READ_IDENTIFICATION_STRING_CNF_DATA_Ttag
{
  TLR_UINT32 ulAddress;
  TLR_UINT8  abData[ASI_MASTER_MAX_READ_IDENTIFICATION_STRING_DATA];

}__PACKED_POST;

/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_READ_DIAGNOSTIC_STRING_REQ_DATA_Ttag</code> */
typedef struct ASI_MASTER_READ_DIAGNOSTIC_STRING_REQ_DATA_Ttag
  ASI_MASTER_READ_DIAGNOSTIC_STRING_REQ_DATA_T;

/** type of <code>ASI_MASTER_READ_DIAGNOSTIC_STRING_CNF_DATA_Ttag</code> */
typedef struct ASI_MASTER_READ_DIAGNOSTIC_STRING_CNF_DATA_Ttag
  ASI_MASTER_READ_DIAGNOSTIC_STRING_CNF_DATA_T;

#define ASI_MASTER_MAX_READ_DIAGNOSTIC_STRING_DATA 220

__PACKED_PRE struct ASI_MASTER_READ_DIAGNOSTIC_STRING_REQ_DATA_Ttag
{
  TLR_UINT32 ulAddress;

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_READ_DIAGNOSTIC_STRING_CNF_DATA_Ttag
{
  TLR_UINT32 ulAddress;
  TLR_UINT8  abData[ASI_MASTER_MAX_READ_DIAGNOSTIC_STRING_DATA];

}__PACKED_POST;

/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_READ_PARAMETER_STRING_REQ_DATA_Ttag</code> */
typedef struct ASI_MASTER_READ_PARAMETER_STRING_REQ_DATA_Ttag
  ASI_MASTER_READ_PARAMETER_STRING_REQ_DATA_T;

/** type of <code>ASI_MASTER_READ_PARAMETER_STRING_CNF_DATA_Ttag</code> */
typedef struct ASI_MASTER_READ_PARAMETER_STRING_CNF_DATA_Ttag
  ASI_MASTER_READ_PARAMETER_STRING_CNF_DATA_T;

#define ASI_MASTER_MAX_READ_PARAMETER_STRING_DATA 220

__PACKED_PRE struct ASI_MASTER_READ_PARAMETER_STRING_REQ_DATA_Ttag
{
  TLR_UINT32 ulAddress;

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_READ_PARAMETER_STRING_CNF_DATA_Ttag
{
  TLR_UINT32 ulAddress;
  TLR_UINT8  abData[ASI_MASTER_MAX_READ_PARAMETER_STRING_DATA];

}__PACKED_POST;

/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_WRITE_PARAMETER_STRING_REQ_DATA_Ttag</code> */
typedef struct ASI_MASTER_WRITE_PARAMETER_STRING_REQ_DATA_Ttag
  ASI_MASTER_WRITE_PARAMETER_STRING_REQ_DATA_T;

/** type of <code>ASI_MASTER_WRITE_PARAMETER_STRING_CNF_DATA_Ttag</code> */
typedef struct ASI_MASTER_WRITE_PARAMETER_STRING_CNF_DATA_Ttag
  ASI_MASTER_WRITE_PARAMETER_STRING_CNF_DATA_T;

#define ASI_MASTER_MAX_WRITE_PARAMETER_STRING_DATA 220

__PACKED_PRE struct ASI_MASTER_WRITE_PARAMETER_STRING_REQ_DATA_Ttag
{
  TLR_UINT32 ulAddress;
  TLR_UINT8  abData[ASI_MASTER_MAX_WRITE_PARAMETER_STRING_DATA];

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_WRITE_PARAMETER_STRING_CNF_DATA_Ttag
{
  TLR_UINT32 ulAddress;

}__PACKED_POST;

/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_SLAVE_CONFIG_DATA_Ttag</code> */
typedef struct ASI_MASTER_SLAVE_CONFIG_DATA_Ttag
  ASI_MASTER_SLAVE_CONFIG_DATA_T;

__PACKED_PRE struct ASI_MASTER_SLAVE_CONFIG_DATA_Ttag
{
    TLR_UINT8 bIoConfig;  /* IO-Config  */
    TLR_UINT8 bIdCode;    /* ID-Code    */
    TLR_UINT8 bId1Code;   /* ID1-Code   */
    TLR_UINT8 bId2Code;   /* ID2-Code   */
}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_APP_REGISTER_REQ_DATA_Ttag</code> */
typedef struct ASI_MASTER_APP_REGISTER_REQ_DATA_Ttag
  ASI_MASTER_APP_REGISTER_REQ_DATA_T;
/** type of <code>ASI_MASTER_APP_REGISTER_CNF_DATA_Ttag</code> */
typedef struct ASI_MASTER_APP_REGISTER_CNF_DATA_Ttag
  ASI_MASTER_APP_REGISTER_CNF_DATA_T;

__PACKED_PRE struct ASI_MASTER_APP_REGISTER_REQ_DATA_Ttag
{
  TLR_UINT32 ulReserved;

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_APP_REGISTER_CNF_DATA_Ttag
{
  TLR_UINT32 ulReserved;

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_GET_BUFFER_HANDLE_CNF_DATA_Ttag</code> */
typedef struct ASI_MASTER_GET_BUFFER_HANDLE_CNF_DATA_Ttag
  ASI_MASTER_GET_BUFFER_HANDLE_CNF_DATA_T;

#define ASI_MASTER_SEND_RECV_BUFFER_SIZE 3584

__PACKED_PRE struct ASI_MASTER_GET_BUFFER_HANDLE_CNF_DATA_Ttag
{
  TLR_UINT32 ulRecvBuffer;
  TLR_UINT32 ulSendBuffer;

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_SET_SLAVE_PARAM_REQ_DATA_Ttag</code> */
typedef struct ASI_MASTER_SET_SLAVE_PARAM_REQ_DATA_Ttag
  ASI_MASTER_SET_SLAVE_PARAM_REQ_DATA_T;

__PACKED_PRE struct ASI_MASTER_SET_SLAVE_PARAM_REQ_DATA_Ttag
{
  ASI_MASTER_SLAVE_PARAM_T tSlaveParam;

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_GET_SLAVE_PARAM_REQ_DATA_Ttag</code> */
typedef struct ASI_MASTER_GET_SLAVE_PARAM_REQ_DATA_Ttag
  ASI_MASTER_GET_SLAVE_PARAM_REQ_DATA_T;

/** type of <code>ASI_MASTER_GET_SLAVE_PARAM_CNF_DATA_Ttag</code> */
typedef struct ASI_MASTER_GET_SLAVE_PARAM_CNF_DATA_Ttag
  ASI_MASTER_GET_SLAVE_PARAM_CNF_DATA_T;

__PACKED_PRE struct ASI_MASTER_GET_SLAVE_PARAM_REQ_DATA_Ttag
{
  TLR_UINT32 ulAddress;

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_GET_SLAVE_PARAM_CNF_DATA_Ttag
{
  ASI_MASTER_SLAVE_PARAM_T tSlaveParam;

}__PACKED_POST;
/*************************************************************************************/


/** type of <code>ASI_MASTER_SET_BUS_PARAM_REQ_DATA_T</code> */
typedef struct ASI_MASTER_SET_BUS_PARAM_REQ_DATA_Ttag
  ASI_MASTER_SET_BUS_PARAM_REQ_DATA_T;

__PACKED_PRE struct ASI_MASTER_SET_BUS_PARAM_REQ_DATA_Ttag
{
  ASI_MASTER_BUS_PARAM_T tBusParam;

}__PACKED_POST;
/*************************************************************************************/


/*************************************************************************************/
/** type of <code>ASI_MASTER_SET_OFFLINE_MODE_REQ_DATA_T</code> */
typedef struct ASI_MASTER_SET_OFFLINE_MODE_REQ_DATA_Ttag
  ASI_MASTER_SET_OFFLINE_MODE_REQ_DATA_T;

#define ASI_MASTER_SET_OFFLINE_MODE       0x00000001L
#define ASI_MASTER_RESET_OFFLINE_MODE     0x00000002L

__PACKED_PRE struct ASI_MASTER_SET_OFFLINE_MODE_REQ_DATA_Ttag
{
  TLR_UINT32 ulOfflineMode;

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_READ_ACTUAL_CONFIG_REQ_DATA_T</code> */
typedef struct ASI_MASTER_READ_ACTUAL_CONFIG_REQ_DATA_Ttag
  ASI_MASTER_READ_ACTUAL_CONFIG_REQ_DATA_T;

/** type of <code>ASI_MASTER_READ_ACTUAL_CONFIG_CNF_DATA_T</code> */
typedef struct ASI_MASTER_READ_ACTUAL_CONFIG_CNF_DATA_Ttag
  ASI_MASTER_READ_ACTUAL_CONFIG_CNF_DATA_T;

__PACKED_PRE struct ASI_MASTER_READ_ACTUAL_CONFIG_REQ_DATA_Ttag
{
  TLR_UINT32 ulAddress;

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_READ_ACTUAL_CONFIG_CNF_DATA_Ttag
{
  TLR_UINT32 ulAddress;
  ASI_MASTER_SLAVE_CONFIG_DATA_T atCdi[ASI_MASTER_MAX_SLAVES];

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_READ_PARAMETER_IMAGE_REQ_DATA_T</code> */
typedef struct ASI_MASTER_READ_PARAMETER_IMAGE_REQ_DATA_Ttag
  ASI_MASTER_READ_PARAMETER_IMAGE_REQ_DATA_T;

/** type of <code>ASI_MASTER_READ_PARAMETER_IMAGE_CNF_DATA_T</code> */
typedef struct ASI_MASTER_READ_PARAMETER_IMAGE_CNF_DATA_Ttag
  ASI_MASTER_READ_PARAMETER_IMAGE_CNF_DATA_T;

__PACKED_PRE struct ASI_MASTER_READ_PARAMETER_IMAGE_REQ_DATA_Ttag
{
  TLR_UINT32 ulAddress;

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_READ_PARAMETER_IMAGE_CNF_DATA_Ttag
{
  TLR_UINT32 ulAddress;
  TLR_UINT32 aulPi[ASI_MASTER_MAX_SLAVES];

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_GET_PERMANENT_CONFIG_REQ_DATA_T</code> */
typedef struct ASI_MASTER_GET_PERMANENT_CONFIG_REQ_DATA_Ttag
  ASI_MASTER_GET_PERMANENT_CONFIG_REQ_DATA_T;

/** type of <code>ASI_MASTER_GET_PERMANENT_CONFIG_CNF_DATA_T</code> */
typedef struct ASI_MASTER_GET_PERMANENT_CONFIG_CNF_DATA_Ttag
  ASI_MASTER_GET_PERMANENT_CONFIG_CNF_DATA_T;

__PACKED_PRE struct ASI_MASTER_GET_PERMANENT_CONFIG_REQ_DATA_Ttag
{
  TLR_UINT32 ulAddress;

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_GET_PERMANENT_CONFIG_CNF_DATA_Ttag
{
  TLR_UINT32 ulAddress;
  ASI_MASTER_SLAVE_CONFIG_DATA_T atPcd[ASI_MASTER_MAX_SLAVES];

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_GET_PERMANENT_PARAMETER_REQ_DATA_T</code> */
typedef struct ASI_MASTER_GET_PERMANENT_PARAMETER_REQ_DATA_Ttag
  ASI_MASTER_GET_PERMANENT_PARAMETER_REQ_DATA_T;

/** type of <code>ASI_MASTER_GET_PERMANENT_PARAMETER_CNF_DATA_T</code> */
typedef struct ASI_MASTER_GET_PERMANENT_PARAMETER_CNF_DATA_Ttag
  ASI_MASTER_GET_PERMANENT_PARAMETER_CNF_DATA_T;

__PACKED_PRE struct ASI_MASTER_GET_PERMANENT_PARAMETER_REQ_DATA_Ttag
{
  TLR_UINT32 ulAddress;

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_GET_PERMANENT_PARAMETER_CNF_DATA_Ttag
{
  TLR_UINT32 ulAddress;
  TLR_UINT32 aulPp[ASI_MASTER_MAX_SLAVES];

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_EXECUTE_COMMAND_REQ_DATA_T</code> */
typedef struct ASI_MASTER_EXECUTE_COMMAND_REQ_DATA_Ttag
  ASI_MASTER_EXECUTE_COMMAND_REQ_DATA_T;

/** type of <code>ASI_MASTER_EXECUTE_COMMAND_CNF_DATA_T</code> */
typedef struct ASI_MASTER_EXECUTE_COMMAND_CNF_DATA_Ttag
  ASI_MASTER_EXECUTE_COMMAND_CNF_DATA_T;

#define ASI_MASTER_EXECUTE_COMMAND_MIN_INFO 0x00000001L
#define ASI_MASTER_EXECUTE_COMMAND_MAX_INFO 0x0000001FL

__PACKED_PRE struct ASI_MASTER_EXECUTE_COMMAND_REQ_DATA_Ttag
{
  TLR_UINT32 ulAddress;
  TLR_UINT32 ulInfo;

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_EXECUTE_COMMAND_CNF_DATA_Ttag
{
  TLR_UINT32 ulAddress;
  TLR_UINT32 ulData;

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_WRITE_PARAMETER_REQ_DATA_T</code> */
typedef struct ASI_MASTER_WRITE_PARAMETER_REQ_DATA_Ttag
  ASI_MASTER_WRITE_PARAMETER_REQ_DATA_T;

/** type of <code>ASI_MASTER_WRITE_PARAMETER_CNF_DATA_T</code> */
typedef struct ASI_MASTER_WRITE_PARAMETER_CNF_DATA_Ttag
  ASI_MASTER_WRITE_PARAMETER_CNF_DATA_T;

#define ASI_MASTER_MAX_PARAM_STD_SLAVE 0x0000000FL
#define ASI_MASTER_MAX_PARAM_EXT_SLAVE 0x00000007L

__PACKED_PRE struct ASI_MASTER_WRITE_PARAMETER_REQ_DATA_Ttag
{
  TLR_UINT32 ulAddress;
  TLR_UINT32 ulParam;

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_WRITE_PARAMETER_CNF_DATA_Ttag
{
  TLR_UINT32 ulAddress;
  TLR_UINT32 ulParam;

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_CHANGE_SLAVE_ADDRESS_REQ_DATA_T</code> */
typedef struct ASI_MASTER_CHANGE_SLAVE_ADDRESS_REQ_DATA_Ttag
  ASI_MASTER_CHANGE_SLAVE_ADDRESS_REQ_DATA_T;

__PACKED_PRE struct ASI_MASTER_CHANGE_SLAVE_ADDRESS_REQ_DATA_Ttag
{
  TLR_UINT32 ulOldAddress;
  TLR_UINT32 ulNewAddress;

}__PACKED_POST;

/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_WRITE_EXT_ID1_CODE_REQ_DATA_T</code> */
typedef struct ASI_MASTER_WRITE_EXT_ID1_CODE_REQ_DATA_Ttag
  ASI_MASTER_WRITE_EXT_ID1_CODE_REQ_DATA_T;

#define ASI_MASTER_MAX_EXT_ID1_CODE_STD_SLAVE 0x0000000FL
#define ASI_MASTER_MAX_EXT_ID1_CODE_EXT_SLAVE 0x00000007L

__PACKED_PRE struct ASI_MASTER_WRITE_EXT_ID1_CODE_REQ_DATA_Ttag
{
  TLR_UINT32 ulExtID1Code;

}__PACKED_POST;

/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_GET_BUS_PARAM_CNF_DATA_T</code> */
typedef struct ASI_MASTER_GET_BUS_PARAM_CNF_DATA_Ttag
  ASI_MASTER_GET_BUS_PARAM_CNF_DATA_T;

__PACKED_PRE struct ASI_MASTER_GET_BUS_PARAM_CNF_DATA_Ttag
{
  ASI_MASTER_BUS_PARAM_T tBusParam;

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_SET_AUTO_ADDRESS_ENABLE_REQ_DATA_T</code> */
typedef struct ASI_MASTER_SET_AUTO_ADDRESS_ENABLE_REQ_DATA_Ttag
  ASI_MASTER_SET_AUTO_ADDRESS_ENABLE_REQ_DATA_T;

__PACKED_PRE struct ASI_MASTER_SET_AUTO_ADDRESS_ENABLE_REQ_DATA_Ttag
{
  TLR_UINT32 ulAutoAddress;

}__PACKED_POST;

/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_GET_AUTO_ADDRESS_ENABLE_CNF_DATA_T</code> */
typedef struct ASI_MASTER_GET_AUTO_ADDRESS_ENABLE_CNF_DATA_Ttag
  ASI_MASTER_GET_AUTO_ADDRESS_ENABLE_CNF_DATA_T;

__PACKED_PRE struct ASI_MASTER_GET_AUTO_ADDRESS_ENABLE_CNF_DATA_Ttag
{
  TLR_UINT32 ulAutoAddress;

}__PACKED_POST;

/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_SET_DATA_EXCHANGE_ACTIVE_REQ_DATA_T</code> */
typedef struct ASI_MASTER_SET_DATA_EXCHANGE_ACTIVE_REQ_DATA_Ttag
  ASI_MASTER_SET_DATA_EXCHANGE_ACTIVE_REQ_DATA_T;

__PACKED_PRE struct ASI_MASTER_SET_DATA_EXCHANGE_ACTIVE_REQ_DATA_Ttag
{
  TLR_UINT32 ulDataExchangeActive;

}__PACKED_POST;

/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_SET_OPERATION_MODE_REQ_DATA_T</code> */
typedef struct ASI_MASTER_SET_OPERATION_MODE_REQ_DATA_Ttag
  ASI_MASTER_SET_OPERATION_MODE_REQ_DATA_T;

__PACKED_PRE struct ASI_MASTER_SET_OPERATION_MODE_REQ_DATA_Ttag
{
  TLR_UINT32 ulOperationMode;

}__PACKED_POST;

/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_STATE_CHANGE_IND_DATA_Ttag</code> */
typedef struct ASI_MASTER_STATE_CHANGE_IND_DATA_Ttag
  ASI_MASTER_STATE_CHANGE_IND_DATA_T;

__PACKED_PRE struct ASI_MASTER_STATE_CHANGE_IND_DATA_Ttag
{
  TLR_UINT32                   ulMasterState;
  NETX_MASTER_STATUS           tMasterState;
  ASI_MASTER_EXTENDED_STATE_T  tExtendedState;
}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_GET_LPS_CNF_DATA_Ttag</code> */
typedef struct ASI_MASTER_GET_LPS_CNF_DATA_Ttag
  ASI_MASTER_GET_LPS_CNF_DATA_T;

__PACKED_PRE struct ASI_MASTER_GET_LPS_CNF_DATA_Ttag
{
  TLR_UINT8  abProjectedList[ASI_MASTER_LIST_SIZE];

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_GET_LAS_CNF_DATA_Ttag</code> */
typedef struct ASI_MASTER_GET_LAS_CNF_DATA_Ttag
  ASI_MASTER_GET_LAS_CNF_DATA_T;

__PACKED_PRE struct ASI_MASTER_GET_LAS_CNF_DATA_Ttag
{
  TLR_UINT8  abActivatedList[ASI_MASTER_LIST_SIZE];

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_GET_LDS_CNF_DATA_Ttag</code> */
typedef struct ASI_MASTER_GET_LDS_CNF_DATA_Ttag
  ASI_MASTER_GET_LDS_CNF_DATA_T;

__PACKED_PRE struct ASI_MASTER_GET_LDS_CNF_DATA_Ttag
{
  TLR_UINT8  abDetectedList[ASI_MASTER_LIST_SIZE];

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_GET_LPF_CNF_DATA_Ttag</code> */
typedef struct ASI_MASTER_GET_LPF_CNF_DATA_Ttag
  ASI_MASTER_GET_LPF_CNF_DATA_T;

__PACKED_PRE struct ASI_MASTER_GET_LPF_CNF_DATA_Ttag
{
  TLR_UINT8  abPeripheryFaultList[ASI_MASTER_LIST_SIZE];

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_GET_EXECUTION_CONTROL_FLAGS_CNF_DATA_Ttag</code> */
typedef struct ASI_MASTER_GET_EXECUTION_CONTROL_FLAGS_CNF_DATA_Ttag
  ASI_MASTER_GET_EXECUTION_CONTROL_FLAGS_CNF_DATA_T;

__PACKED_PRE struct ASI_MASTER_GET_EXECUTION_CONTROL_FLAGS_CNF_DATA_Ttag
{
  TLR_UINT16 usAsiFlags;

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_GET_SLAVE_DIAG_REQ_DATA_Ttag</code> */
typedef struct ASI_MASTER_GET_SLAVE_DIAG_REQ_DATA_Ttag
  ASI_MASTER_GET_SLAVE_DIAG_REQ_DATA_T;

/** type of <code>ASI_MASTER_GET_SLAVE_DIAG_CNF_DATA_Ttag</code> */
typedef struct ASI_MASTER_GET_SLAVE_DIAG_CNF_DATA_Ttag
  ASI_MASTER_GET_SLAVE_DIAG_CNF_DATA_T;

#define ASI_MASTER_DIAG_REQ_FLAG_PEEK                   0x00000001L

__PACKED_PRE struct ASI_MASTER_GET_SLAVE_DIAG_REQ_DATA_Ttag
{
  TLR_UINT32 ulAddress;
  TLR_UINT32 ulReqFlags;

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_GET_SLAVE_DIAG_CNF_DATA_Ttag
{
  TLR_UINT32 ulAddress;
  TLR_UINT32 ulReqFlags;
  ASI_MASTER_SLAVE_DIAG_T tSlaveDiag;

}__PACKED_POST;
/*************************************************************************************/

/** @} */

/** @name Packet Definition
 *
 * The following definied structures represent the packets of the several services,
 * which are supported by the task.
 * @{
 */

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_APP_REGISTER_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_APP_REGISTER_REQ_Ttag
  ASI_MASTER_PACKET_APP_REGISTER_REQ_T;
/** type of <code>ASI_MASTER_PACKET_APP_REGISTER_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_APP_REGISTER_CNF_Ttag
  ASI_MASTER_PACKET_APP_REGISTER_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_APP_REGISTER_REQ_Ttag
{
  TLR_PACKET_HEADER_T                tHead;  /** packet header.       */
  ASI_MASTER_APP_REGISTER_REQ_DATA_T tData;  /** packet request data. */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_APP_REGISTER_CNF_Ttag
{
  TLR_PACKET_HEADER_T                tHead; /** packet header.            */
  ASI_MASTER_APP_REGISTER_CNF_DATA_T tData; /** packet confirmation data. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_INITIALIZE_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_INITIALIZE_REQ_Ttag
  ASI_MASTER_PACKET_INITIALIZE_REQ_T;
/** type of <code>ASI_MASTER_PACKET_INITIALIZE_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_INITIALIZE_CNF_Ttag
  ASI_MASTER_PACKET_INITIALIZE_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_INITIALIZE_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;  /** packet header.       */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_INITIALIZE_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;  /** packet header.            */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_GET_BUFFER_HANDLE_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_GET_BUFFER_HANDLE_REQ_Ttag
  ASI_MASTER_PACKET_GET_BUFFER_HANDLE_REQ_T;
/** type of <code>ASI_MASTER_PACKET_GET_BUFFER_HANDLE_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_GET_BUFFER_HANDLE_CNF_Ttag
  ASI_MASTER_PACKET_GET_BUFFER_HANDLE_CNF_T;

struct ASI_MASTER_PACKET_GET_BUFFER_HANDLE_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;  /** packet header.            */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_BUFFER_HANDLE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;  /** packet header.            */
  ASI_MASTER_GET_BUFFER_HANDLE_CNF_DATA_T tData;  /** packet request data.      */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_SET_BUS_PARAM_REQ_T</code> */
typedef struct ASI_MASTER_PACKET_SET_BUS_PARAM_REQ_Ttag
  ASI_MASTER_PACKET_SET_BUS_PARAM_REQ_T;
/** type of <code>ASI_MASTER_PACKET_SET_BUS_PARAM_CNF_T</code> */
typedef struct ASI_MASTER_PACKET_SET_BUS_PARAM_CNF_Ttag
  ASI_MASTER_PACKET_SET_BUS_PARAM_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_SET_BUS_PARAM_REQ_Ttag
{
  TLR_PACKET_HEADER_T                 tHead; /** packet header */
  ASI_MASTER_SET_BUS_PARAM_REQ_DATA_T tData; /** packet data   */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_SET_BUS_PARAM_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;                 /** packet header */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_SET_SLAVE_PARAM_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_SET_SLAVE_PARAM_REQ_Ttag
  ASI_MASTER_PACKET_SET_SLAVE_PARAM_REQ_T;
/** type of <code>ASI_MASTER_PACKET_SET_SLAVE_PARAM_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_SET_SLAVE_PARAM_CNF_Ttag
  ASI_MASTER_PACKET_SET_SLAVE_PARAM_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_SET_SLAVE_PARAM_REQ_Ttag
{
  TLR_PACKET_HEADER_T                    tHead; /** packet header */
  ASI_MASTER_SET_SLAVE_PARAM_REQ_DATA_T  tData; /** packet data   */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_SET_SLAVE_PARAM_CNF_Ttag
{
  TLR_PACKET_HEADER_T                   tHead; /** packet header */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_GET_SLAVE_PARAM_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_GET_SLAVE_PARAM_REQ_Ttag
  ASI_MASTER_PACKET_GET_SLAVE_PARAM_REQ_T;
/** type of <code>ASI_MASTER_PACKET_GET_SLAVE_PARAM_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_GET_SLAVE_PARAM_CNF_Ttag
  ASI_MASTER_PACKET_GET_SLAVE_PARAM_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_SLAVE_PARAM_REQ_Ttag
{
  TLR_PACKET_HEADER_T                    tHead; /** packet header */
  ASI_MASTER_GET_SLAVE_PARAM_REQ_DATA_T  tData; /** packet data   */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_SLAVE_PARAM_CNF_Ttag
{
  TLR_PACKET_HEADER_T                   tHead; /** packet header */
  ASI_MASTER_GET_SLAVE_PARAM_CNF_DATA_T tData; /** packet data   */

}__PACKED_POST;
/*************************************************************************************/



/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_GET_BUS_PARAM_REQ_T</code> */
typedef struct ASI_MASTER_PACKET_GET_BUS_PARAM_REQ_Ttag
  ASI_MASTER_PACKET_GET_BUS_PARAM_REQ_T;
/** type of <code>ASI_MASTER_PACKET_GET_BUS_PARAM_CNF_T</code> */
typedef struct ASI_MASTER_PACKET_GET_BUS_PARAM_CNF_Ttag
  ASI_MASTER_PACKET_GET_BUS_PARAM_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_BUS_PARAM_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead; /** packet header */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_BUS_PARAM_CNF_Ttag
{
  TLR_PACKET_HEADER_T                 tHead; /** packet header */
  ASI_MASTER_GET_BUS_PARAM_CNF_DATA_T tData; /** packet data   */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_SET_OFFLINE_MODE_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_SET_OFFLINE_MODE_REQ_Ttag
  ASI_MASTER_PACKET_SET_OFFLINE_MODE_REQ_T;
/** type of <code>ASI_MASTER_PACKET_SET_OFFLINE_MODE_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_SET_OFFLINE_MODE_CNF_Ttag
  ASI_MASTER_PACKET_SET_OFFLINE_MODE_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_SET_OFFLINE_MODE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;  /** packet header.  */
  ASI_MASTER_SET_OFFLINE_MODE_REQ_DATA_T  tData;  /** packet data     */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_SET_OFFLINE_MODE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;  /** packet header. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_READ_ACTUAL_CONFIG_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_READ_ACTUAL_CONFIG_REQ_Ttag
  ASI_MASTER_PACKET_READ_ACTUAL_CONFIG_REQ_T;
/** type of <code>ASI_MASTER_PACKET_READ_ACTUAL_CONFIG_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_READ_ACTUAL_CONFIG_CNF_Ttag
  ASI_MASTER_PACKET_READ_ACTUAL_CONFIG_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_READ_ACTUAL_CONFIG_REQ_Ttag
{
  TLR_PACKET_HEADER_T                      tHead;  /** packet header.  */
  ASI_MASTER_READ_ACTUAL_CONFIG_REQ_DATA_T tData;  /** packet data     */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_READ_ACTUAL_CONFIG_CNF_Ttag
{
  TLR_PACKET_HEADER_T                      tHead;  /** packet header. */
  ASI_MASTER_READ_ACTUAL_CONFIG_CNF_DATA_T tData;  /** packet data    */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_READ_PARAMETER_IMAGE_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_READ_PARAMETER_IMAGE_REQ_Ttag
  ASI_MASTER_PACKET_READ_PARAMETER_IMAGE_REQ_T;
/** type of <code>ASI_MASTER_PACKET_READ_PARAMETER_IMAGE_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_READ_PARAMETER_IMAGE_CNF_Ttag
  ASI_MASTER_PACKET_READ_PARAMETER_IMAGE_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_READ_PARAMETER_IMAGE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                        tHead;  /** packet header.  */
  ASI_MASTER_READ_PARAMETER_IMAGE_REQ_DATA_T tData;  /** packet data     */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_READ_PARAMETER_IMAGE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                        tHead;  /** packet header. */
  ASI_MASTER_READ_PARAMETER_IMAGE_CNF_DATA_T tData;  /** packet data    */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_GET_PERMANENT_CONFIG_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_GET_PERMANENT_CONFIG_REQ_Ttag
  ASI_MASTER_PACKET_GET_PERMANENT_CONFIG_REQ_T;
/** type of <code>ASI_MASTER_PACKET_GET_PERMANENT_CONFIG_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_GET_PERMANENT_CONFIG_CNF_Ttag
  ASI_MASTER_PACKET_GET_PERMANENT_CONFIG_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_PERMANENT_CONFIG_REQ_Ttag
{
  TLR_PACKET_HEADER_T                        tHead;  /** packet header.  */
  ASI_MASTER_GET_PERMANENT_CONFIG_REQ_DATA_T tData;  /** packet data     */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_PERMANENT_CONFIG_CNF_Ttag
{
  TLR_PACKET_HEADER_T                        tHead;  /** packet header. */
  ASI_MASTER_GET_PERMANENT_CONFIG_CNF_DATA_T tData;  /** packet data    */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_GET_PERMANENT_PARAMETER_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_GET_PERMANENT_PARAMETER_REQ_Ttag
  ASI_MASTER_PACKET_GET_PERMANENT_PARAMETER_REQ_T;
/** type of <code>ASI_MASTER_PACKET_GET_PERMANENT_PARAMETER_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_GET_PERMANENT_PARAMETER_CNF_Ttag
  ASI_MASTER_PACKET_GET_PERMANENT_PARAMETER_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_PERMANENT_PARAMETER_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;  /** packet header.  */
  ASI_MASTER_GET_PERMANENT_PARAMETER_REQ_DATA_T tData;  /** packet data     */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_PERMANENT_PARAMETER_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;  /** packet header. */
  ASI_MASTER_GET_PERMANENT_PARAMETER_CNF_DATA_T tData;  /** packet data    */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_EXECUTE_COMMAND_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_EXECUTE_COMMAND_REQ_Ttag
  ASI_MASTER_PACKET_EXECUTE_COMMAND_REQ_T;
/** type of <code>ASI_MASTER_PACKET_EXECUTE_COMMAND_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_EXECUTE_COMMAND_CNF_Ttag
  ASI_MASTER_PACKET_EXECUTE_COMMAND_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_EXECUTE_COMMAND_REQ_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;  /** packet header.  */
  ASI_MASTER_EXECUTE_COMMAND_REQ_DATA_T tData;  /** packet data     */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_EXECUTE_COMMAND_CNF_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;  /** packet header. */
  ASI_MASTER_EXECUTE_COMMAND_CNF_DATA_T tData;  /** packet data    */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_WRITE_PARAMETER_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_WRITE_PARAMETER_REQ_Ttag
  ASI_MASTER_PACKET_WRITE_PARAMETER_REQ_T;
/** type of <code>ASI_MASTER_PACKET_WRITE_PARAMETER_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_WRITE_PARAMETER_CNF_Ttag
  ASI_MASTER_PACKET_WRITE_PARAMETER_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_WRITE_PARAMETER_REQ_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;  /** packet header.  */
  ASI_MASTER_WRITE_PARAMETER_REQ_DATA_T tData;  /** packet data     */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_WRITE_PARAMETER_CNF_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;  /** packet header. */
  ASI_MASTER_WRITE_PARAMETER_CNF_DATA_T tData;  /** packet data    */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_CHANGE_SLAVE_ADDRESS_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_CHANGE_SLAVE_ADDRESS_REQ_Ttag
  ASI_MASTER_PACKET_CHANGE_SLAVE_ADDRESS_REQ_T;
/** type of <code>ASI_MASTER_PACKET_CHANGE_SLAVE_ADDRESS_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_CHANGE_SLAVE_ADDRESS_CNF_Ttag
  ASI_MASTER_PACKET_CHANGE_SLAVE_ADDRESS_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_CHANGE_SLAVE_ADDRESS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                        tHead;  /** packet header.  */
  ASI_MASTER_CHANGE_SLAVE_ADDRESS_REQ_DATA_T tData;  /** packet data     */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_CHANGE_SLAVE_ADDRESS_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;  /** packet header. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_WRITE_EXT_ID1_CODE_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_WRITE_EXT_ID1_CODE_REQ_Ttag
  ASI_MASTER_PACKET_WRITE_EXT_ID1_CODE_REQ_T;
/** type of <code>ASI_MASTER_PACKET_WRITE_EXT_ID1_CODE_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_WRITE_EXT_ID1_CODE_CNF_Ttag
  ASI_MASTER_PACKET_WRITE_EXT_ID1_CODE_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_WRITE_EXT_ID1_CODE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                      tHead;  /** packet header.  */
  ASI_MASTER_WRITE_EXT_ID1_CODE_REQ_DATA_T tData;  /** packet data     */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_WRITE_EXT_ID1_CODE_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;  /** packet header. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_SET_AUTO_ADDRESS_ENABLE_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_SET_AUTO_ADDRESS_ENABLE_REQ_Ttag
  ASI_MASTER_PACKET_SET_AUTO_ADDRESS_ENABLE_REQ_T;
/** type of <code>ASI_MASTER_PACKET_SET_AUTO_ADDRESS_ENABLE_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_SET_AUTO_ADDRESS_ENABLE_CNF_Ttag
  ASI_MASTER_PACKET_SET_AUTO_ADDRESS_ENABLE_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_SET_AUTO_ADDRESS_ENABLE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                            tHead;  /** packet header.  */
  ASI_MASTER_SET_AUTO_ADDRESS_ENABLE_REQ_DATA_T  tData;  /** packet data     */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_SET_AUTO_ADDRESS_ENABLE_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;  /** packet header. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_GET_AUTO_ADDRESS_ENABLE_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_GET_AUTO_ADDRESS_ENABLE_REQ_Ttag
  ASI_MASTER_PACKET_GET_AUTO_ADDRESS_ENABLE_REQ_T;
/** type of <code>ASI_MASTER_PACKET_GET_AUTO_ADDRESS_ENABLE_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_GET_AUTO_ADDRESS_ENABLE_CNF_Ttag
  ASI_MASTER_PACKET_GET_AUTO_ADDRESS_ENABLE_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_AUTO_ADDRESS_ENABLE_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;  /** packet header.  */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_AUTO_ADDRESS_ENABLE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                            tHead;  /** packet header.  */
  ASI_MASTER_GET_AUTO_ADDRESS_ENABLE_CNF_DATA_T  tData;  /** packet data     */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_SET_DATA_EXCHANGE_ACTIVE_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_SET_DATA_EXCHANGE_ACTIVE_REQ_Ttag
  ASI_MASTER_PACKET_SET_DATA_EXCHANGE_ACTIVE_REQ_T;
/** type of <code>ASI_MASTER_PACKET_SET_DATA_EXCHANGE_ACTIVE_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_SET_DATA_EXCHANGE_ACTIVE_CNF_Ttag
  ASI_MASTER_PACKET_SET_DATA_EXCHANGE_ACTIVE_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_SET_DATA_EXCHANGE_ACTIVE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;  /** packet header.  */
  ASI_MASTER_SET_DATA_EXCHANGE_ACTIVE_REQ_DATA_T  tData;  /** packet data     */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_SET_DATA_EXCHANGE_ACTIVE_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;  /** packet header. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_SET_OPERATION_MODE_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_SET_OPERATION_MODE_REQ_Ttag
  ASI_MASTER_PACKET_SET_OPERATION_MODE_REQ_T;
/** type of <code>ASI_MASTER_PACKET_SET_OPERATION_MODE_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_SET_OPERATION_MODE_CNF_Ttag
  ASI_MASTER_PACKET_SET_OPERATION_MODE_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_SET_OPERATION_MODE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;  /** packet header.  */
  ASI_MASTER_SET_OPERATION_MODE_REQ_DATA_T  tData;  /** packet data     */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_SET_OPERATION_MODE_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;  /** packet header. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_STATE_CHANGE_IND_Ttag</code> */
typedef struct ASI_MASTER_PACKET_STATE_CHANGE_IND_Ttag
  ASI_MASTER_PACKET_STATE_CHANGE_IND_T;
/** type of <code>ASI_MASTER_PACKET_STATE_CHANGE_RES_Ttag</code> */
typedef struct ASI_MASTER_PACKET_STATE_CHANGE_RES_Ttag
  ASI_MASTER_PACKET_STATE_CHANGE_RES_T;

__PACKED_PRE struct ASI_MASTER_PACKET_STATE_CHANGE_IND_Ttag
{
  TLR_PACKET_HEADER_T                tHead;  /** packet header.            */
  ASI_MASTER_STATE_CHANGE_IND_DATA_T tData;  /** packet request data.      */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_STATE_CHANGE_RES_Ttag
{
  TLR_PACKET_HEADER_T tHead; /** packet header.            */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_GET_LPS_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_GET_LPS_REQ_Ttag
  ASI_MASTER_PACKET_GET_LPS_REQ_T;
/** type of <code>ASI_MASTER_PACKET_GET_LPS_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_GET_LPS_CNF_Ttag
  ASI_MASTER_PACKET_GET_LPS_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_LPS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;  /** packet header.  */
}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_LPS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;  /** packet header. */
  ASI_MASTER_GET_LPS_CNF_DATA_T                 tData;  /** packet data    */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_GET_LAS_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_GET_LAS_REQ_Ttag
  ASI_MASTER_PACKET_GET_LAS_REQ_T;
/** type of <code>ASI_MASTER_PACKET_GET_LAS_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_GET_LAS_CNF_Ttag
  ASI_MASTER_PACKET_GET_LAS_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_LAS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;  /** packet header.  */
}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_LAS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;  /** packet header. */
  ASI_MASTER_GET_LAS_CNF_DATA_T                 tData;  /** packet data    */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_GET_LDS_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_GET_LDS_REQ_Ttag
  ASI_MASTER_PACKET_GET_LDS_REQ_T;
/** type of <code>ASI_MASTER_PACKET_GET_LDS_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_GET_LDS_CNF_Ttag
  ASI_MASTER_PACKET_GET_LDS_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_LDS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;  /** packet header.  */
}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_LDS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;  /** packet header. */
  ASI_MASTER_GET_LDS_CNF_DATA_T                 tData;  /** packet data    */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_GET_LPF_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_GET_LPF_REQ_Ttag
  ASI_MASTER_PACKET_GET_LPF_REQ_T;
/** type of <code>ASI_MASTER_PACKET_GET_LPF_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_GET_LPF_CNF_Ttag
  ASI_MASTER_PACKET_GET_LPF_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_LPF_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;  /** packet header.  */
}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_LPF_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;  /** packet header. */
  ASI_MASTER_GET_LPF_CNF_DATA_T                 tData;  /** packet data    */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_GET_EXECUTION_CONTROL_FLAGS_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_GET_EXECUTION_CONTROL_FLAGS_REQ_Ttag
  ASI_MASTER_PACKET_GET_EXECUTION_CONTROL_FLAGS_REQ_T;
/** type of <code>ASI_MASTER_PACKET_GET_EXECUTION_CONTROL_FLAGS_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_GET_EXECUTION_CONTROL_FLAGS_CNF_Ttag
  ASI_MASTER_PACKET_GET_EXECUTION_CONTROL_FLAGS_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_EXECUTION_CONTROL_FLAGS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;  /** packet header.  */
}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_EXECUTION_CONTROL_FLAGS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                                 tHead;  /** packet header. */
  ASI_MASTER_GET_EXECUTION_CONTROL_FLAGS_CNF_DATA_T   tData;  /** packet data    */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_READ_WRITE_OBJECT_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_READ_WRITE_OBJECT_REQ_Ttag
  ASI_MASTER_PACKET_READ_WRITE_OBJECT_REQ_T;
/** type of <code>ASI_MASTER_PACKET_READ_WRITE_OBJECT_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_READ_WRITE_OBJECT_CNF_Ttag
  ASI_MASTER_PACKET_READ_WRITE_OBJECT_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_READ_WRITE_OBJECT_REQ_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;  /** packet header.  */
  ASI_MASTER_READ_WRITE_OBJECT_DATA_T   tData;  /** packet data    */
}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_READ_WRITE_OBJECT_CNF_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;  /** packet header. */
  ASI_MASTER_READ_WRITE_OBJECT_DATA_T   tData;  /** packet data    */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_READ_IDENTIFICATION_STRING_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_READ_IDENTIFICATION_STRING_REQ_Ttag
  ASI_MASTER_PACKET_READ_IDENTIFICATION_STRING_REQ_T;
/** type of <code>ASI_MASTER_PACKET_READ_IDENTIFICATION_STRING_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_READ_IDENTIFICATION_STRING_CNF_Ttag
  ASI_MASTER_PACKET_READ_IDENTIFICATION_STRING_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_READ_IDENTIFICATION_STRING_REQ_Ttag
{
  TLR_PACKET_HEADER_T                                tHead;  /** packet header.  */
  ASI_MASTER_READ_IDENTIFICATION_STRING_REQ_DATA_T   tData;  /** packet data    */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_READ_IDENTIFICATION_STRING_CNF_Ttag
{
  TLR_PACKET_HEADER_T                               tHead;  /** packet header. */
  ASI_MASTER_READ_IDENTIFICATION_STRING_CNF_DATA_T  tData;  /** packet data    */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_READ_PARAMETER_STRING_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_READ_PARAMETER_STRING_REQ_Ttag
  ASI_MASTER_PACKET_READ_PARAMETER_STRING_REQ_T;
/** type of <code>ASI_MASTER_PACKET_READ_PARAMETER_STRING_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_READ_PARAMETER_STRING_CNF_Ttag
  ASI_MASTER_PACKET_READ_PARAMETER_STRING_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_READ_PARAMETER_STRING_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;  /** packet header.  */
  ASI_MASTER_READ_PARAMETER_STRING_REQ_DATA_T   tData;  /** packet data    */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_READ_PARAMETER_STRING_CNF_Ttag
{
  TLR_PACKET_HEADER_T                          tHead;  /** packet header. */
  ASI_MASTER_READ_PARAMETER_STRING_CNF_DATA_T  tData;  /** packet data    */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_WRITE_PARAMETER_STRING_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_WRITE_PARAMETER_STRING_REQ_Ttag
  ASI_MASTER_PACKET_WRITE_PARAMETER_STRING_REQ_T;
/** type of <code>ASI_MASTER_PACKET_WRITE_PARAMETER_STRING_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_WRITE_PARAMETER_STRING_CNF_Ttag
  ASI_MASTER_PACKET_WRITE_PARAMETER_STRING_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_WRITE_PARAMETER_STRING_REQ_Ttag
{
  TLR_PACKET_HEADER_T                            tHead;  /** packet header.  */
  ASI_MASTER_WRITE_PARAMETER_STRING_REQ_DATA_T   tData;  /** packet data    */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_WRITE_PARAMETER_STRING_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;  /** packet header. */
  ASI_MASTER_WRITE_PARAMETER_STRING_CNF_DATA_T  tData;  /** packet data    */

}__PACKED_POST;
/*************************************************************************************/


/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_READ_DIAGNOSTIC_STRING_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_READ_DIAGNOSTIC_STRING_REQ_Ttag
  ASI_MASTER_PACKET_READ_DIAGNOSTIC_STRING_REQ_T;
/** type of <code>ASI_MASTER_PACKET_READ_DIAGNOSTIC_STRING_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_READ_DIAGNOSTIC_STRING_CNF_Ttag
  ASI_MASTER_PACKET_READ_DIAGNOSTIC_STRING_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_READ_DIAGNOSTIC_STRING_REQ_Ttag
{
  TLR_PACKET_HEADER_T                            tHead;  /** packet header.  */
  ASI_MASTER_READ_DIAGNOSTIC_STRING_REQ_DATA_T   tData;  /** packet data    */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_READ_DIAGNOSTIC_STRING_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;  /** packet header. */
  ASI_MASTER_READ_DIAGNOSTIC_STRING_CNF_DATA_T  tData;  /** packet data    */

}__PACKED_POST;
/*************************************************************************************/


/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_GET_SLAVE_DIAG_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_GET_SLAVE_DIAG_REQ_Ttag
  ASI_MASTER_PACKET_GET_SLAVE_DIAG_REQ_T;
/** type of <code>ASI_MASTER_PACKET_GET_SLAVE_DIAG_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_GET_SLAVE_DIAG_CNF_Ttag
  ASI_MASTER_PACKET_GET_SLAVE_DIAG_CNF_T;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_SLAVE_DIAG_REQ_Ttag
{
  TLR_PACKET_HEADER_T                     tHead;  /** packet header.  */
  ASI_MASTER_GET_SLAVE_DIAG_REQ_DATA_T   tData;  /** packet data    */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_GET_SLAVE_DIAG_CNF_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;  /** packet header. */
  ASI_MASTER_GET_SLAVE_DIAG_CNF_DATA_T  tData;  /** packet data    */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>ASI_MASTER_TRANSPARENT_COMMAND_REQ_DATA_T</code> */
typedef struct ASI_MASTER_TRANSPARENT_COMMAND_REQ_DATA_Ttag
  ASI_MASTER_TRANSPARENT_COMMAND_REQ_DATA_T;

/** type of <code>ASI_MASTER_TRANSPARENT_COMMAND_CNF_DATA_T</code> */
typedef struct ASI_MASTER_TRANSPARENT_COMMAND_CNF_DATA_Ttag
  ASI_MASTER_TRANSPARENT_COMMAND_CNF_DATA_T;

#define ASI_MASTER_TRANSPARENT_COMMAND_CMD_BIT_CLEAR       0x00000000L
#define ASI_MASTER_TRANSPARENT_COMMAND_CMD_BIT_SET         0x00000001L

#define ASI_MASTER_TRANSPARENT_COMMAND_MAX_ADDRESS         0x0000001FL
#define ASI_MASTER_TRANSPARENT_COMMAND_MAX_INFO            0x0000001FL

#define ASI_MASTER_TRANSPARENT_COMMAND_TRANSACTION_TYPE_ST 0x00000000L
#define ASI_MASTER_TRANSPARENT_COMMAND_TRANSACTION_TYPE_MT 0x00000001L

__PACKED_PRE struct ASI_MASTER_TRANSPARENT_COMMAND_REQ_DATA_Ttag
{
  TLR_UINT32 ulCommand;
  TLR_UINT32 ulAddress;
  TLR_UINT32 ulInfo;
  TLR_UINT32 ulTransactionType;

}__PACKED_POST;

#define ASI_MASTER_TRANSPARENT_BUS_ERROR_POWER_FAIL_MSK     0x00000001L
#define ASI_MASTER_TRANSPARENT_BUS_ERROR_TIMEOUT_MSK        0x00000002L
#define ASI_MASTER_TRANSPARENT_BUS_ERROR_MANCHESTER_MSK     0x00000004L
#define ASI_MASTER_TRANSPARENT_BUS_ERROR_PARITY_MSK         0x00000008L
#define ASI_MASTER_TRANSPARENT_BUS_ERROR_FRAMING_MSK        0x00000010L
#define ASI_MASTER_TRANSPARENT_BUS_ERROR_FRAME_LENGHT_MSK   0x00000020L
#define ASI_MASTER_TRANSPARENT_BUS_ERROR_UNKOWN_MSK         0x80000000L

__PACKED_PRE struct ASI_MASTER_TRANSPARENT_COMMAND_CNF_DATA_Ttag
{
  TLR_UINT32 ulCommand;
  TLR_UINT32 ulAddress;
  TLR_UINT32 ulInfo;
  TLR_UINT32 ulTransactionType;

  TLR_UINT32 ulBusError;
  TLR_UINT32 ulData;

}__PACKED_POST;



/*************************************************************************************/
/*************************************************************************************/
/** type of <code>ASI_MASTER_PACKET_TRANSPARENT_COMMAND_REQ_Ttag</code> */
typedef struct ASI_MASTER_PACKET_TRANSPARENT_COMMAND_REQ_Ttag
  ASI_MASTER_PACKET_TRANSPARENT_COMMAND_REQ_T;
/** type of <code>ASI_MASTER_PACKET_TRANSPARENT_COMMAND_CNF_Ttag</code> */
typedef struct ASI_MASTER_PACKET_TRANSPARENT_COMMAND_CNF_Ttag
  ASI_MASTER_PACKET_TRANSPARENT_COMMAND_CNF_T;

#define ASI_MASTER_MAX_TRANSPARENT_REQ      16

__PACKED_PRE struct ASI_MASTER_PACKET_TRANSPARENT_COMMAND_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;  /** packet header.  */
  ASI_MASTER_TRANSPARENT_COMMAND_REQ_DATA_T tData;  /** packet data    */

}__PACKED_POST;

__PACKED_PRE struct ASI_MASTER_PACKET_TRANSPARENT_COMMAND_CNF_Ttag
{
  TLR_PACKET_HEADER_T                       tHead;  /** packet header. */
  ASI_MASTER_TRANSPARENT_COMMAND_CNF_DATA_T tData;  /** packet data    */

}__PACKED_POST;
/*************************************************************************************/

/** @} */

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__ASI_MASTER_PACKET)
#endif


/*************************************************************************************/
#endif /* #ifndef __ASI_MASTER_PUBLIC_H */

/*************************************************************************************/
/*-----------------------------------------------------------------------------------*/
/*-------------------------- EOF ----------------------------------------------------*/
/*-----------------------------------------------------------------------------------*/
/*************************************************************************************/
